﻿[//lasso
/*----------------------------------------------------------------------------

[yahoo_news]
Retrieves the specified feed data from Yahoo! News.

Author: Jason Huck
Last Modified: Jul. 20, 2006
License: Artistic license <http://opensource.org/licenses/artistic-license.php>

Description:
Given a valid feed name for Yahoo! News, returns the current feed data as an 
array of maps.


Sample Usage:
var('mynews') = yahoo_news('topstories');

iterate($mynews, local('i'));
	'<h4><a href="' + #i->find('link') + '" target="_blank">' + #i->find('title') + '</a></h4>\n';
	'<small>' + #i->find('pubDate')->format('%D') + '</small>\n';
	'<p>' + #i->find('description') + '</p>\n';
/iterate;


Downloaded from tagSwap.net on Feb. 14, 2007.
Latest version available from <http://tagSwap.net/yahoo_news>.

----------------------------------------------------------------------------*/
		

define_tag(
	'news',
	-namespace='yahoo_',
	-req='feed',
	-priority='replace',
	-description='Retrieves the specified news feed from Yahoo! News.'
);
	local('out' = array);

	protect;
		local('data') = xml_tree(include_url('http://rss.news.yahoo.com/rss/' + #feed));
		
		handle_error;
			return;
		/handle_error;
	/protect;
	
	local('nodes') = array(
		'title',
		'link',
		'guid',
		'pubDate',
		'description',
		'content',
		'text',
		'credit'
	);
	
	iterate(#data->channel->item, local('i'));		
		local('temp' = map);
		
		iterate(#nodes, local('n'));
			protect;
				local('raw') = decode_html(#i->getnode(#n)->contents);
				#raw->trim;
				#n == 'pubDate' ? #raw = date(#raw, -format='%a, %d %b %Y %H:%M:%S GMT');	// Thu, 20 Jul 2006 16:22:22 GMT
				#temp->insert(#n = #raw);
			/protect;
		/iterate;
		
		#out->insert(#temp);
	/iterate;
	
	return(#out);
/define_tag;
]
